#!/bin/bash
#
# LanTEK-IV first boot script
# This script is run by init-hw.sh (via lantek4-init.service) if /opt/LanTEK/tmp/lanek4FirstBoot
# is found at startup, which is normally created in the rootfs during full rootfs image creation,
# it will start CCMB upgrade

LANTEK_DIR=/opt/LanTEK
RESOURCES_DIR=${LANTEK_DIR}/resources
SCRIPTS_DIR=${LANTEK_DIR}/scripts
CCMB_DIR=${SCRIPTS_DIR}/ccmb
MAIN_SERVICE="lantek4-gui"
FIRST_BOOT=${LANTEK_DIR}/tmp/runFirstBoot
LED_FLASH=lt4LEDflashDH
LANGUAGE="ENGLISH"
SCREENS_PATH=${LANTEK_DIR}/tmp/screens/${LANGUAGE}
#size bmp file displayable content (16bits per pixel) is 480*854*2 = 819840
#SKIP_BYTES is the number of bytes to skip past the bmp header.
FB0_SIZE=819840
SKIP_BYTES=68
UPGRADE_DONE=0

RhCpu=$(grep UltraLite /proc/cpuinfo)

RH=0
if [ "$RhCpu" != "" ]; then
    RH=1
    MAIN_SERVICE="lantek4-console"
    LED_FLASH=lt4LEDflashRH
fi

#handle Autotest button for DH
function set_keys() {
    if [ $RH -eq 0 ]; then
	#Autotest key 
	if [ ! -d /sys/class/gpio/gpio148 ]; then
            echo 148 > /sys/class/gpio/export
            echo in > /sys/class/gpio/gpio148/direction
	fi
    fi
}

show_update_image() {
    if [ $RH -eq 0 ]; then
        #maximum backlight brightness
        echo 7 > /sys/class/backlight/backlight/brightness
        #display correct language update screens
        if [ -f ${LANTEK_DIR}/tmp/language ]; then
            LANGUAGE=`cat ${LANTEK_DIR}/tmp/language` 
            SCREENS_PATH=${LANTEK_DIR}/tmp/screens/${LANGUAGE}            
        fi
        if [ -f $SCREENS_PATH/final1.bmp ]; then
            /bin/dd if=$SCREENS_PATH/final1.bmp skip=$SKIP_BYTES of=/dev/fb0 iflag=skip_bytes
        else
            echo "can't find:"$SCREENS_PATH/final1.bmp
        fi
    fi
}
#wait for 180 seconds
wait_for_ccmb_interface() {
startTime="$(date -u +%s)"
for var in {1..180}
do
        nc -z -w 1 192.168.9.2 9000 > /dev/null 2>&1
        ccmbStatus=$?

        currentTime="$(date -u +%s)"
        elapsed=$((currentTime - startTime))

        if [ $ccmbStatus -eq 0 ] ; then
                echo "iterations $var"
                echo "elapsed $elapsed"
                break
        fi
        sleep 1
        printf '.'
done
    return $ccmbStatus
}

ccmb_upgrade() {

    killall install-update.sh

    show_update_image

    wait_for_ccmb_interface
    ccmbActive=$?
    echo $ccmbActive

    #Donot remove CCMB from known hosts as otherwise many ssh commands could fail if there are no comms to CCMB at this point
    if [ $ccmbActive -eq 0 ]; then
        ssh-keygen -R 192.168.9.2
    fi
    ssh-keyscan -H 192.168.9.2 >> ~/.ssh/known_hosts
    sync

    ${CCMB_DIR}/install-update.sh
    status=$?

    eval $1=$status

    printf "done $status\n"
}

ccmb_upgrade_finished() {
    # CCMB upgrade finshed...
            
    #unmount USB (only has effect if mounted!)
    umount /dev/sda1 2> /dev/null

    
    if [ $RH -eq 0 ]; then    
        echo "Stop flashing the LEDs now.."
        killall lt4LEDflashDH.sh
        #and make sure LEDs of left OFF
        
        #select 'Connected LED'
        i2cset -y 0 0x07 0x10 c
        #set colour 
        i2cset -y 0 0x07 0x0 c
        #select 'Hazard LED'
        i2cset -y 0 0x07 0x11 c
        #set colour 
        i2cset -y 0 0x07 0x0 c

        if [ -f $SCREENS_PATH/final2.bmp ]; then
            /bin/dd if=$SCREENS_PATH/final2.bmp skip=$SKIP_BYTES of=/dev/fb0 iflag=skip_bytes
        else
            echo "can't find:"$SCREENS_PATH/final2.bmp
            #no need to hang around in here as the upgrade is finished anyway.. so just break out of this function
        fi
        #wait for AUTOTEST button press then update the screen image to show final3 bmp
	while true
        do       
            if cat /sys/class/gpio/gpio148/value | grep -xqFe "0" ; then
                if [ -f $SCREENS_PATH/final3.bmp ]; then
                    /bin/dd if=$SCREENS_PATH/final3.bmp skip=$SKIP_BYTES of=/dev/fb0 iflag=skip_bytes
                    sleep 2
                    #now wait again for Autotest to be pressed to Quit the script...
                    while true
                    do       
                        if cat /sys/class/gpio/gpio148/value | grep -xqFe "0" ; then
                            break
                        fi
                    done
                else
                    echo "can't find:"$SCREENS_PATH/final3.bmp
                fi
                break
            fi
       done	
    fi
}

#-------------------
#Script starts here
#-------------------

# check if the first boot flag file exists
[ ! -f ${FIRST_BOOT} ] && exit 0

printf "doing upgrade - stop main service\n"
#keep in the dark for now
echo 0 > /sys/class/backlight/backlight/brightness

#don't let console go to sleep as this has the effect of turning off backlight which we don't want!
setterm -term linux -blank 0 >/dev/tty1

#start flashing progress LEDs in background
${SCRIPTS_DIR}/${LED_FLASH}.sh &

if [ $RH -eq 0 ]; then
    set_keys
fi    
#check and enable swap memory if necessary as 4.x needs more memory to complete the update
if [ $RH -eq 0 ]; then
    ${SCRIPTS_DIR}/swap_memory/enable.sh
fi

CCMB_UPGRADE_FAILED=0
#check and upgrade CCMB
ccmb_upgrade CCMB_UPGRADE_FAILED

if [ $CCMB_UPGRADE_FAILED -eq 0 ]; then
    echo "CCMB upgrade succeeded"
else
    echo "CCMB upgrade failed"
fi

UPGRADE_DONE=1

#disable swap memory
if [ $RH -eq 0 ]; then
    ${SCRIPTS_DIR}/swap_memory/disable.sh
fi

ccmb_upgrade_finished

#for DH handle kernel name change (if any) and selection of splash screen for correct model LTIV or LTIV S
if [ $RH -eq 0 ]; then
 cp /opt/LanTEK/resources/splash/splashLTIV*.bmp /boot/
 #--------------------------------------
 existing_kernel=$(uname -r)
 echo kernel_name: $existing_kernel

 rootfs_uses=$(ls /lib/modules)
 echo rootfs_uses: $rootfs_uses

 if [[ ${existing_kernel} != ${rootfs_uses} ]]; then
     echo rename contents of /lib/modules/
     mv /lib/modules/$rootfs_uses /lib/modules/$existing_kernel
 fi

# #-------------------------------------
# #determine how much memory (DRAM) - using this snippet from clever person on internet!
# #based on the memory size, select the correct u-boot splash image to use in /boot/
 while IFS=":" read -r a b
 do
   case "$a" in
    MemTotal*) phys_mem="$b"
   esac
 done <"/proc/meminfo"
 #echo /proc/meminfo: $phys_mem

 #chop off the last 3 bytes to leave just the number for comparison...
 truncated_phys_mem=${phys_mem%???}
 echo memory fitted: $truncated_phys_mem

 #512MB lanTEKs show as '504512 kB'
 #1024MB lanTEKs show as '1024312 kB'
 memory_size_model_S=1024312

 #do integer comparison...
 if (( ${truncated_phys_mem} < ${memory_size_model_S} )); then
   echo using /boot/splashLTIV.bmp
   cp /boot/splashLTIV.bmp /boot/splash.bmp
 else
   echo using /boot/splashLTIV-S.bmp
   cp /boot/splashLTIV-S.bmp /boot/splash.bmp
 fi
 #----------------------------------------------
 #get model type from stm to choose correct splash screen for LanTEK IV-L model
 #get 2nd line of output as the first contains text-Dumping flash contents..."
    model="$(stmflash D 44 2 | cut -d ':' -f 2 | sed '2p;d')"
    if [ $model -eq 0200 ]; then
        cp /boot/splashLTIV-L.bmp /boot/splash.bmp
    fi
    echo "ModelType is :"$model
fi
#remove the first boot flag file
rm ${FIRST_BOOT}

if [ $RH -eq 0 ]; then
    rm ${LANTEK_DIR}/tmp/language
    rm -rf ${LANTEK_DIR}/tmp/screens
fi

#stop flashing progress LEDs
killall ${LED_FLASH}.sh
#and make sure LEDs of left OFF
if [ $RH -eq 0 ]; then
    #select 'Connected LED'
    i2cset -y 0 0x07 0x10 c
    #set colour
    i2cset -y 0 0x07 0x0 c
    #select 'Hazard LED'
    i2cset -y 0 0x07 0x11 c
    #set colour
    i2cset -y 0 0x07 0x0 c
else
    #LED1 off
    i2cset -y 0 0x07 0x1c c
    i2cset -y 0 0x07 0x0 c
    #LED2 off
    i2cset -y 0 0x07 0x1d c
    i2cset -y 0 0x07 0x0 c
    #turn off 'Remote LED'
    i2cset -y 0 0x07 0x15 c
    #set colour
    i2cset -y 0 0x07 0x0 c
fi
#just before returning, because the /lib/modules/ contents may have changed, a reboot is required for the new kernel to work with the updated rootfs
reboot

exit 0
